using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;
using System.Data.Linq;

namespace VIRP.EFR.DAL
{
	public partial class ANALYSIS_DETAILDB : DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public ANALYSIS_DETAILDB()
        {
        }

		#endregion

		#region Properties
		#endregion

		#region Methods

		public ANALYSIS_DETAIL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ANALYSIS_DETAIL_ID)
		{
			ANALYSIS_DETAIL objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_ANALYSIS_DETAIL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ANALYSIS_DETAIL_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        if (objReturn.RESULT_UNIT_ID > 0)
                            objReturn.STD_UNIT = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.RESULT_UNIT_ID).FirstOrDefault();

                        if (objReturn.LAB_REFERENCE_RANGE_UNIT_ID > 0)
                            objReturn.STD_UNIT1 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.LAB_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                        if (objReturn.TEFSC_REFERENCE_RANGE_UNIT_ID > 0)
                            objReturn.STD_UNIT2 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.TEFSC_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                        if (objReturn.STD_FRAGMENT_ANALYSIS_TYPE_ID > 0)
                            objReturn.STD_FRAGMENT_ANALYSIS_TYPE = dbContext.usp_STD_FRAGMENT_ANALYSIS_TYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_FRAGMENT_ANALYSIS_TYPE_ID).FirstOrDefault();
                    }
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<ANALYSIS_DETAIL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<ANALYSIS_DETAIL> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_ANALYSIS_DETAIL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<ANALYSIS_DETAIL> GetItemsBySpecimen(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_ANALYSIS_DETAIL_getitemsBySpecimen(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID).ToList();
                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (ANALYSIS_DETAIL det in objReturn)
                        {
                            if (det.RESULT_UNIT_ID > 0)
                                det.STD_UNIT = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.RESULT_UNIT_ID).FirstOrDefault();

                            if (det.LAB_REFERENCE_RANGE_UNIT_ID > 0)
                                det.STD_UNIT1 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.LAB_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                            if (det.TEFSC_REFERENCE_RANGE_UNIT_ID > 0)
                                det.STD_UNIT2 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.TEFSC_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                            if (det.STD_FRAGMENT_ANALYSIS_TYPE_ID > 0)
                                det.STD_FRAGMENT_ANALYSIS_TYPE = dbContext.usp_STD_FRAGMENT_ANALYSIS_TYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.STD_FRAGMENT_ANALYSIS_TYPE_ID).FirstOrDefault();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ANALYSIS_DETAIL> GetItemsByFragment(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_ANALYSIS_DETAIL_getitemsByFragment(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID).ToList();
                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (ANALYSIS_DETAIL det in objReturn)
                        {
                            if (det.RESULT_UNIT_ID > 0)
                                det.STD_UNIT = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.RESULT_UNIT_ID).FirstOrDefault();

                            if (det.LAB_REFERENCE_RANGE_UNIT_ID > 0)
                                det.STD_UNIT1 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.LAB_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                            if (det.TEFSC_REFERENCE_RANGE_UNIT_ID > 0)
                                det.STD_UNIT2 = dbContext.usp_STD_UNITS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.TEFSC_REFERENCE_RANGE_UNIT_ID).FirstOrDefault();

                            if (det.STD_FRAGMENT_ANALYSIS_TYPE_ID > 0)
                                det.STD_FRAGMENT_ANALYSIS_TYPE = dbContext.usp_STD_FRAGMENT_ANALYSIS_TYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.STD_FRAGMENT_ANALYSIS_TYPE_ID).FirstOrDefault();

                            if (det.STD_ANALYTETYPE_ID > 0)
                                det.STD_ANALYTETYPE = dbContext.usp_STD_ANALYTETYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, det.STD_ANALYTETYPE_ID).FirstOrDefault();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ANALYSIS_DETAIL> GetItemsByFragmentExact(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_ANALYSIS_DETAIL_getitemsByFragmentExact(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_ANALYSIS_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ANALYSIS_DETAIL> GetItemsBySpecimenAnalysisId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SPECIMEN_ANALYSIS_ID)
        {
            List<ANALYSIS_DETAIL> details = null;
            List<STD_ANALYSISMETHOD> methods = null;
            List<STD_UNITS> units = null;
            List<BO.STD_TEST_NAME> tests = null;
            List<BO.STD_ANALYTETYPE> analytes = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    IMultipleResults sprocResults = dbContext.usp_ANALYSIS_DETAIL_getitemsBySpecimenAnalysisId(CURRENT_USER, CURRENT_REGISTRY_ID, SPECIMEN_ANALYSIS_ID);

                    details = sprocResults.GetResult<ANALYSIS_DETAIL>().ToList();
                    methods = sprocResults.GetResult<STD_ANALYSISMETHOD>().ToList();
                    units = sprocResults.GetResult<STD_UNITS>().ToList();
                    tests = sprocResults.GetResult<BO.STD_TEST_NAME>().ToList();
                    analytes = sprocResults.GetResult<BO.STD_ANALYTETYPE>().ToList();

                    LogManager.LogTiming(logDetails);
                }

                if (details != null && details.Any())
                {
                    foreach (ANALYSIS_DETAIL detail in details)
                    {
                        if (detail.STD_ANALYSISMETHOD_ID.HasValue)
                            detail.STD_ANALYSISMETHOD = methods.SingleOrDefault(m => m.ID == detail.STD_ANALYSISMETHOD_ID.Value);

                        if (detail.RESULT_UNIT_ID.HasValue)
                            detail.STD_UNIT2 = units.SingleOrDefault(u => u.ID == detail.RESULT_UNIT_ID.Value);

                        if (detail.TEFSC_REFERENCE_RANGE_UNIT_ID.HasValue)
                            detail.STD_UNIT1 = units.SingleOrDefault(u => u.ID == detail.TEFSC_REFERENCE_RANGE_UNIT_ID.Value);

                        if (detail.LAB_REFERENCE_RANGE_UNIT_ID.HasValue)
                            detail.STD_UNIT = units.SingleOrDefault(u => u.ID == detail.LAB_REFERENCE_RANGE_UNIT_ID.Value);

                        if (detail.STD_TEST_NAME_ID.HasValue)
                            detail.STD_TEST_NAME = tests.SingleOrDefault(t => t.ID == detail.STD_TEST_NAME_ID.Value);

                        if (detail.STD_ANALYTETYPE_ID.HasValue)
                            detail.STD_ANALYTETYPE = analytes.SingleOrDefault(a => a.ID == detail.STD_ANALYTETYPE_ID.Value);
                    }

                    return details;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return null;
        }

        public List<ANALYSIS_DETAIL> GetBioAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_ANALYSIS_DETAIL_getBioAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<ANALYSIS_DETAIL> GetFragmentAnalytes(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            List<ANALYSIS_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_ANALYSIS_DETAIL_getFragmentAnalytes(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, ANALYSIS_DETAIL objSave)
		{
			Int32? objReturn = objSave.ANALYSIS_DETAIL_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_ANALYSIS_DETAIL_save(CURRENT_USER, CURRENT_REGISTRY_ID, ref objReturn, objSave.ANALYSIS_METHOD_NAME, objSave.ANALYTE_NAME, objSave.CAS_NUMBER, objSave.CREATED, objSave.CREATEDBY, objSave.CUSTOM_INDICATOR_NUMBER, objSave.CUSTOM_RANGE_NUMBER, objSave.EVAL_COMMENT_TEXT, objSave.FRAGMENT_ANALYSIS_ID, objSave.LAB_ABOVE_REFERENCE_RANGE, objSave.LAB_REFERENCE_RANGE, objSave.LAB_REFERENCE_RANGE_UNIT_ID, objSave.OTHER_ANALYTETYPE_NAME, objSave.OTHER_COMMENT_TEXT, objSave.RESULT_TEXT, objSave.RESULT_UNIT_ID, objSave.SITE_CODE, objSave.SPECIMEN_ANALYSIS_ID, objSave.STD_ANALYSISMETHOD_ID, objSave.STD_ANALYTETYPE_ID, objSave.STD_FRAGMENT_ANALYSIS_TYPE_ID, objSave.STD_TEST_NAME_ID, objSave.TEFSC_ABOVE_REFERENCE_RANGE, objSave.TEFSC_REFERENCE_RANGE, objSave.TEFSC_REFERENCE_RANGE_UNIT_ID, objSave.TEST_NAME, objSave.UPDATED, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ANALYSIS_DETAIL_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_ANALYSIS_DETAIL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ANALYSIS_DETAIL_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public void LoadBioLabResults(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int caseId)
        {
            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.sp_LoadBioLabResults(caseId);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
        }

        #endregion
    }
}
